<?php
/**
 * Plugin Name:       NXT Floating Chat Widget
 * Plugin URI:        https://nxtwebsite.com/wordpress/nxt-floating-chat-widget/
 * Description:       A lightweight, customizable floating chat button that opens WhatsApp with an optional pre-filled message. Position, size options, and optional click tracking.
 * Version:           1.0.0
 * Requires at least: 6.0
 * Requires PHP:      7.4
 * Author:            NXT Website Solutions
 * Author URI:        https://nxtwebsite.com/
 * License:           GPLv2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       nxt-floating-chat-widget
 * Domain Path:       /languages
 *
 * @package NXTFCW
 */

if (!defined('ABSPATH')) exit;

// Constants
define('NXTFCW_VERSION', '1.0.0');
define('NXTFCW_FILE', __FILE__);
define('NXTFCW_DIR', plugin_dir_path(__FILE__));
define('NXTFCW_URL', plugin_dir_url(__FILE__));

// Default options (snake_case per WP standards)
function nxtfcw_default_options() {
    return [
        'phone'    => '1234567890',
        'message'  => __('Hello! I need assistance.', 'nxt-floating-chat-widget'),
        'position' => 'bottom-right', // bottom-right, bottom-left, top-right, top-left
        'size'     => 'medium',       // small, medium, large
        'tracking' => 0,              // 0=off, 1=on
    ];
}

// Includes
require_once NXTFCW_DIR . 'includes/settings-page.php';
require_once NXTFCW_DIR . 'includes/enqueue.php';
require_once NXTFCW_DIR . 'includes/frontend.php';
require_once NXTFCW_DIR . 'includes/tracker.php';
