<?php
if (!defined('ABSPATH')) exit;

/**
 * Render the floating button in the footer
 */
function nxtfcw_render_button() {
    $o = nxtfcw_get_options();

    $phone   = preg_replace('/\D+/', '', $o['phone']); // wa.me requires digits only
    $message = rawurlencode($o['message']);            // URL-safe (supports spaces/emojis)

    if (!$phone) return;

    $icon = NXTFCW_URL . 'assets/images/chat-icon.svg';

    // Build classes
    $position_class = 'nxtfcw--' . $o['position'];
    $size_class     = 'nxtfcw--' . $o['size'];

    $href = "https://wa.me/{$phone}?text={$message}";
    ?>
    <div id="nxtfcw-widget"
         class="<?php echo esc_attr( $position_class . ' ' . $size_class ); ?>"
         aria-label="<?php esc_attr_e('WhatsApp Floating Button', 'nxt-floating-chat-widget'); ?>">
        <a id="nxtfcw-button"
           href="<?php echo esc_url( $href ); ?>"
           target="_blank"
           rel="noopener"
           aria-label="<?php esc_attr_e('Chat with us on WhatsApp', 'nxt-floating-chat-widget'); ?>">
            <img src="<?php echo esc_url( $icon ); ?>"
                 alt="<?php esc_attr_e('Chat Icon', 'nxt-floating-chat-widget'); ?>">
        </a>
    </div>
    <?php
}
add_action('wp_footer', 'nxtfcw_render_button');
