<?php
if (!defined('ABSPATH')) exit;

/**
 * Enqueue frontend assets
 */
function nxtfcw_enqueue_assets() {
    $opts = nxtfcw_get_options();

    // CSS
    wp_enqueue_style(
        'nxtfcw-style',
        NXTFCW_URL . 'assets/css/style.css',
        [],
        NXTFCW_VERSION
    );

    // JS
    wp_enqueue_script(
        'nxtfcw-script',
        NXTFCW_URL . 'assets/js/script.js',
        ['jquery'],
        NXTFCW_VERSION,
        true
    );

    wp_localize_script('nxtfcw-script', 'NXTFCW', [
        'ajax_url'   => admin_url('admin-ajax.php'),
        'nonce'      => wp_create_nonce('nxtfcw_click'),
        'tracking'   => (int) $opts['tracking'],
        'buttonId'   => 'nxtfcw-button',
    ]);
}
add_action('wp_enqueue_scripts', 'nxtfcw_enqueue_assets');
