<?php
/**
 * Uninstall cleanup for NXT WA Floating Widget (NXTFCW).
 */
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Remove options
delete_option('nxtfcw_options');
delete_option('nxtfcw_clicks');

// Also clean multisite network sites if used via network-activate
if (is_multisite()) {
    $sites = get_sites();
    foreach ($sites as $site) {
        switch_to_blog($site->blog_id);
        delete_option('nxtfcw_options');
        delete_option('nxtfcw_clicks');
        restore_current_blog();
    }
}
