<?php
if (!defined('ABSPATH')) exit;

/**
 * AJAX: increment click counter
 */
function nxtfcw_ajax_track_click() {
    check_ajax_referer('nxtfcw_click', 'nonce');

    $opts = nxtfcw_get_options();
    if (empty($opts['tracking'])) {
        wp_send_json_success(['tracked' => false, 'reason' => 'tracking_disabled']);
    }

    $count = (int) get_option('nxtfcw_clicks', 0);
    $count++;
    update_option('nxtfcw_clicks', $count, false);

    wp_send_json_success(['tracked' => true, 'clicks' => $count]);
}
add_action('wp_ajax_nxtfcw_track_click', 'nxtfcw_ajax_track_click');
add_action('wp_ajax_nopriv_nxtfcw_track_click', 'nxtfcw_ajax_track_click');
