<?php
if (!defined('ABSPATH')) exit;

/**
 * Settings: register + admin page
 */

function nxtfcw_get_options() {
    $defaults = nxtfcw_default_options();
    $options  = get_option('nxtfcw_options', []);
    if (!is_array($options)) $options = [];
    return wp_parse_args($options, $defaults);
}

function nxtfcw_register_settings() {
    register_setting('nxtfcw_settings_group', 'nxtfcw_options', [
        'type'              => 'array',
        'sanitize_callback' => 'nxtfcw_sanitize_options',
        'default'           => nxtfcw_default_options(),
    ]);

    add_settings_section(
        'nxtfcw_main_section',
        __('Floating Button Settings', 'nxt-floating-chat-widget'),
        '__return_false',
        'nxtfcw_settings'
    );

    add_settings_field(
        'nxtfcw_phone',
        __('WhatsApp Number', 'nxt-floating-chat-widget'),
        'nxtfcw_field_phone',
        'nxtfcw_settings',
        'nxtfcw_main_section'
    );

    add_settings_field(
        'nxtfcw_message',
        __('Pre-filled Message', 'nxt-floating-chat-widget'),
        'nxtfcw_field_message',
        'nxtfcw_settings',
        'nxtfcw_main_section'
    );

    add_settings_field(
        'nxtfcw_position',
        __('Button Position', 'nxt-floating-chat-widget'),
        'nxtfcw_field_position',
        'nxtfcw_settings',
        'nxtfcw_main_section'
    );

    add_settings_field(
        'nxtfcw_size',
        __('Button Size', 'nxt-floating-chat-widget'),
        'nxtfcw_field_size',
        'nxtfcw_settings',
        'nxtfcw_main_section'
    );

    add_settings_field(
        'nxtfcw_tracking',
        __('Click Tracking', 'nxt-floating-chat-widget'),
        'nxtfcw_field_tracking',
        'nxtfcw_settings',
        'nxtfcw_main_section'
    );
}
add_action('admin_init', 'nxtfcw_register_settings');

function nxtfcw_sanitize_options($input) {
    $out = nxtfcw_default_options();

    // Phone: keep digits only (international format without + for wa.me)
    if (isset($input['phone'])) {
        $digits = preg_replace('/\D+/', '', $input['phone']);
        $out['phone'] = $digits ?: $out['phone'];
    }

    // Message: plain text
    if (isset($input['message'])) {
        $out['message'] = sanitize_text_field($input['message']);
    }

    // Position
    $allowed_positions = ['bottom-right','bottom-left','top-right','top-left'];
    if (isset($input['position']) && in_array($input['position'], $allowed_positions, true)) {
        $out['position'] = $input['position'];
    }

    // Size
    $allowed_sizes = ['small','medium','large'];
    if (isset($input['size']) && in_array($input['size'], $allowed_sizes, true)) {
        $out['size'] = $input['size'];
    }

    // Tracking
    $out['tracking'] = !empty($input['tracking']) ? 1 : 0;

    return $out;
}

function nxtfcw_add_settings_page() {
    add_options_page(
        __('NXT Floating Chat Widget', 'nxt-floating-chat-widget'),
        __('NXT Floating Chat Widget', 'nxt-floating-chat-widget'),
        'manage_options',
        'nxtfcw_settings',
        'nxtfcw_render_settings_page'
    );
}
add_action('admin_menu', 'nxtfcw_add_settings_page');

function nxtfcw_field_phone() {
    $o = nxtfcw_get_options();
    ?>
    <input type="text" name="nxtfcw_options[phone]" value="<?php echo esc_attr($o['phone']); ?>" placeholder="911234567890" class="regular-text" />
    <p class="description"><?php esc_html_e('Enter your WhatsApp number in international format without + or spaces.', 'nxt-floating-chat-widget'); ?></p>
    <?php
}

function nxtfcw_field_message() {
    $o = nxtfcw_get_options();
    ?>
    <input type="text" name="nxtfcw_options[message]" value="<?php echo esc_attr($o['message']); ?>" class="regular-text" />
    <p class="description"><?php esc_html_e('This message will be pre-filled in the chat window.', 'nxt-floating-chat-widget'); ?></p>
    <?php
}

function nxtfcw_field_position() {
    $o = nxtfcw_get_options();
    $choices = [
        'bottom-right' => __('Bottom Right', 'nxt-floating-chat-widget'),
        'bottom-left'  => __('Bottom Left',  'nxt-floating-chat-widget'),
        'top-right'    => __('Top Right',    'nxt-floating-chat-widget'),
        'top-left'     => __('Top Left',     'nxt-floating-chat-widget'),
    ];
    ?>
    <select name="nxtfcw_options[position]">
        <?php foreach ($choices as $val => $label): ?>
            <option value="<?php echo esc_attr($val); ?>" <?php selected($o['position'], $val); ?>>
                <?php echo esc_html($label); ?>
            </option>
        <?php endforeach; ?>
    </select>
    <?php
}

function nxtfcw_field_size() {
    $o = nxtfcw_get_options();
    $choices = [
        'small'  => __('Small', 'nxt-floating-chat-widget'),
        'medium' => __('Medium', 'nxt-floating-chat-widget'),
        'large'  => __('Large', 'nxt-floating-chat-widget'),
    ];
    ?>
    <select name="nxtfcw_options[size]">
        <?php foreach ($choices as $val => $label): ?>
            <option value="<?php echo esc_attr($val); ?>" <?php selected($o['size'], $val); ?>>
                <?php echo esc_html($label); ?>
            </option>
        <?php endforeach; ?>
    </select>
    <p class="description"><?php esc_html_e('Responsive by default: auto-scales slightly on small screens.', 'nxt-floating-chat-widget'); ?></p>
    <?php
}

function nxtfcw_field_tracking() {
    $o = nxtfcw_get_options();
    ?>
    <label>
        <input type="checkbox" name="nxtfcw_options[tracking]" value="1" <?php checked($o['tracking'], 1); ?> />
        <?php esc_html_e('Enable click tracking', 'nxt-floating-chat-widget'); ?>
    </label>
    <p class="description">
        <?php
        printf(
            /* translators: %d: clicks */
            esc_html__('Total tracked clicks: %d', 'nxt-floating-chat-widget'),
            intval(get_option('nxtfcw_clicks', 0))
        );
        ?>
    </p>
    <?php
}

function nxtfcw_render_settings_page() {
    ?>
    <div class="wrap">
        <h1><?php esc_html_e('NXT Floating Chat Widget', 'nxt-floating-chat-widget'); ?></h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('nxtfcw_settings_group');
            do_settings_sections('nxtfcw_settings');
            submit_button();
            ?>
        </form>
    </div>
    <?php
}
